/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.internal.build.properties;

import com.aptana.core.util.StringUtil;
import com.aptana.css.core.internal.build.AptanaCSSInheritanceProperties;
import com.aptana.css.core.internal.build.AptanaCSSStyle;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;

public abstract class CustomCSSProperty
extends CssProperty {
    private final String propertyName;

    protected CustomCSSProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        AptanaCSSStyle aptanaStyle = (AptanaCSSStyle)style;
        if (aptanaStyle.getProperty(this.getPropertyName()) != null) {
            aptanaStyle.addRedefinitionWarning(ac, this);
        }
        aptanaStyle.setProperty(this.getPropertyName(), this);
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        AptanaCSSStyle aptanaStyle = (AptanaCSSStyle)style;
        if (resolve) {
            return aptanaStyle.getPropertyCascadingOrder(this.getPropertyName());
        }
        return aptanaStyle.getProperty(this.getPropertyName());
    }

    public boolean Inherited() {
        return AptanaCSSInheritanceProperties.getInheritance(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean equals(CssProperty property) {
        if (!(property instanceof CustomCSSProperty)) {
            return false;
        }
        Object value = this.get();
        return value != null && value.equals(property.get());
    }

    public String toString() {
        Object value = this.get();
        return value == null ? "" : value.toString();
    }

    protected String getPropertyNameNoMinus() {
        String propertyName = this.getPropertyName();
        if (StringUtil.isEmpty((String)propertyName)) {
            return propertyName;
        }
        if (propertyName.charAt(0) == '-') {
            return propertyName.substring(1);
        }
        return propertyName;
    }
}

